<?php
declare(strict_types=1);

if (!defined('DOCROOT')) {
    // DOCROOT may be defined somewhere elswhere, like in the `index.php` file
    define('DOCROOT', realpath(__DIR__ . '/../') . DIRECTORY_SEPARATOR);
}

// Use Composer's autoloader to gain access to all the funky & candy tools
require DOCROOT . 'src/vendor/autoload.php';

// Set up dependencies
require DOCROOT . 'src/config/dependencies.php';

/** @var \Psr\Container\ContainerInterface $container */
if (!in_array(
    $container->get(\Noodlehaus\ConfigInterface::class)->get('mode'),
    ['production', 'staging', 'development'],
    true
)) {
    throw new \RuntimeException('Unknown application mode');
}

// Instantiate the app
\Slim\Factory\AppFactory::setContainer($container);
$app = \Slim\Factory\AppFactory::create();

$errorMiddleware = $app->addErrorMiddleware(
    true,
    true,
    true,
    $app->getContainer()->get(\Psr\Log\LoggerInterface::class)
);

// Register middleware
require DOCROOT . 'src/config/middleware.php';

// Register routes
require DOCROOT . 'src/config/routes.php';

// Run app and catch exceptions
$app->run();
