<?php
declare(strict_types=1);

namespace FCA\Bootstrapper\Bootstrap\Action;

use FCA\Bootstrapper\Bootstrap\Project;

class CopyTemplates extends \FCA\Bootstrapper\Bootstrap\AbstractAction
{
    public function __invoke()
    {
        /** @var Project $project */
        $project = $this->container->get(Project::class);
        $vars = [
            '%%PROJECT_NAMESPACE%%' => rtrim($project->getPsr4namespace(), '\\'),
        ];

        $templates_dir = BASE_PROJECT_DIRECTORY . '/resources/bootstrap_templates/';
        foreach (new \RecursiveIteratorIterator(new \RecursiveDirectoryIterator($templates_dir, \FilesystemIterator::SKIP_DOTS)) as $fileInfo) {
            if ($fileInfo->isDir()) {
                continue;
            }

            if (!$fileInfo->isReadable()) {
                throw new \RuntimeException('Template "' . $fileInfo->getFilename() . '" is not readable');
            }

            $buffer = file_get_contents($fileInfo->getPathname());
            $buffer = strtr($buffer, $vars);

            $target_path = BASE_PROJECT_DIRECTORY . '/' . substr($fileInfo->getPathname(), strlen($templates_dir));
            $target_directory = pathinfo($target_path, PATHINFO_DIRNAME);
            if (!file_exists($target_directory)) {
                // Note that directory creation is, possibly, only 1-level deep
                mkdir($target_directory);
            }
            $template_extension = '.template';
            if (substr_compare($target_path, $template_extension, -strlen($template_extension)) === 0) {
                // Filename ends with ".template" (this is the actual extension to be removed)
                $target_path = substr($target_path, 0, -strlen($template_extension));
            }
            file_put_contents($target_path, $buffer);
        }
    }
}
