<?php
declare(strict_types=1);

namespace FCA\Bootstrapper\Bootstrap\Action;

use FCA\Bootstrapper\Bootstrap\Project;

class PickProjectNamespace extends \FCA\Bootstrapper\Bootstrap\AbstractAction
{
    public function __invoke()
    {
        /** @var \League\CLImate\CLImate $climate */
        $climate = $this->container->get(\League\CLImate\CLImate::class);

        do {
            $input = $climate->lightGreen()->input(
                'You shall now pick the namespace for your new application (like "fca-poland/foo-bar"):'
            );
            $response = $input->prompt();
        } while (!preg_match('|^[a-z0-9-]+/[a-z0-9-]+$|', $response));

        /** @var Project $project */
        $project = $this->container->get(Project::class);
        $project->setNamespace($response);
    }
}
