<?php
declare(strict_types=1);

namespace FCA\Bootstrapper\Bootstrap\Action;

use FCA\Bootstrapper\Bootstrap\Project;

class Psr4Autoload extends \FCA\Bootstrapper\Bootstrap\AbstractAction
{
    public function __invoke()
    {
        /** @var \League\CLImate\CLImate $climate */
        $climate = $this->container->get(\League\CLImate\CLImate::class);

        /** @var Project $project */
        $project = $this->container->get(Project::class);

        do {
            $default_namespace = $project->getPsr4Namespace();
            $input = $climate->lightGreen()->input(
                'Please define a PSR-4 autoload namespace for your application that will point to ' .
                '"src/classes" directory or press Enter to accept  "' . $default_namespace . ':');
            $input->defaultTo($default_namespace);
            $response = $input->prompt();
        } while (!preg_match('|^[a-zA-Z0-9]+\\\[a-zA-Z0-9]+$|', $response));

        $project->setPsr4namespace(trim($response, '\\') . '\\');
    }
}
