<?php
declare(strict_types=1);

namespace FCA\Bootstrapper\Bootstrap;

class Project
{
    /**
     * @var string[] Array of 'name' => 'email' relations
     */
    private array $authors = [];

    private ?string $base_dir;

    private ?string $namespace;

    private ?string $description;

    private ?string $license;

    private bool $climate = false;

    private ?string $psr4namespace;

    /**
     * @return string[]
     */
    public function getAuthors(): array
    {
        return $this->authors;
    }

    /**
     * @param string[] $authors
     */
    public function setAuthors(array $authors): void
    {
        $this->authors = $authors;
    }

    public function getBaseDir(): ?string
    {
        return $this->base_dir;
    }

    public function setBaseDir(?string $base_dir): void
    {
        $this->base_dir = $base_dir;
    }

    public function getNamespace(): ?string
    {
        return $this->namespace;
    }

    public function setNamespace(?string $namespace): void
    {
        if (!isset($this->namespace)) {
            $psr4_namespace = strtr(ucwords($namespace, '/-'), ['/' => '\\', '-' => '']);
            // One fixed exception: change "FcaPoland\\DealerPanel\\" namespace to "FCA\\DealerPanel\\"...
            $psr4_namespace = preg_replace('|^FcaPoland\\\\(.*)|', 'FCA\\\\\1', $psr4_namespace);
            $this->setPsr4namespace($psr4_namespace);
        }
        $this->namespace = $namespace;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function setDescription(?string $description): void
    {
        $this->description = $description;
    }

    public function getLicense(): ?string
    {
        return $this->license;
    }

    public function setLicense(?string $license): void
    {
        $this->license = $license;
    }

    public function getClimate(): bool
    {
        return $this->climate;
    }

    public function setClimate(bool $flag): void
    {
        $this->climate = $flag;
    }

    public function getPsr4namespace(): ?string
    {
        return $this->psr4namespace;
    }

    public function setPsr4namespace(?string $namespace): void
    {
        $this->psr4namespace = $namespace;
    }
}
