<?php
declare(strict_types=1);

namespace FCA\Bootstrapper\Bootstrap\Action;

class RemoveBootstrapFiles extends \FCA\Bootstrapper\Bootstrap\AbstractAction
{
    public function __invoke()
    {
        $this->removeNonEmptyDirectory(BASE_PROJECT_DIRECTORY . '/src/classes/Bootstrap');
        $this->removeNonEmptyDirectory(BASE_PROJECT_DIRECTORY . '/resources/bootstrap_templates');
    }

    private function removeNonEmptyDirectory(string $dir): bool
    {
        if (!file_exists($dir) or !is_dir($dir) or !is_writable($dir)) {
            return true;
        }
        $files = array_diff(scandir($dir), ['.', '..']);
        foreach ($files as $file) {
            (is_dir("$dir/$file"))
                ? $this->removeNonEmptyDirectory("$dir/$file")
                : unlink("$dir/$file");
        }

        return rmdir($dir);
    }
}
