<?php
declare(strict_types=1);

namespace FCA\Bootstrapper\Bootstrap\Action;

use FCA\Bootstrapper\Bootstrap\Service;
use FCA\Bootstrapper\Bootstrap\Project;

class UpdateComposerJson extends \FCA\Bootstrapper\Bootstrap\AbstractAction
{
    public function __invoke()
    {
        /** @var \ArrayObject $composer_config */
        $composer_config = $this->container->get(Service\ComposerConfig::class)->getConfig();
        /** @var Project $project */
        $project = $this->container->get(Project::class);

        // Remove "post-create-project-cmd" from "scripts"...
        unset($composer_config['scripts']['post-create-project-cmd']);
        if (!isset($composer_config['scripts']) or !$composer_config['scripts']) {
            unset($composer_config['scripts']);
        }

        if ($name = $project->getNamespace()) {
            $composer_config['name'] = $name;
        } else {
            unset($composer_config['name']);
        }
        unset($name);
        if ($description = $project->getDescription()) {
            $composer_config['description'] = $description;
        } else {
            unset($composer_config['description']);
        }
        unset($description);
        if ($license = $project->getLicense()) {
            $composer_config['license'] = $license;
        } else {
            unset($composer_config['license']);
        }
        unset($license);
        if ($authors = $project->getAuthors()) {
            $composer_config['authors'] = $authors;
        } else {
            unset($composer_config['authors']);
        }
        unset($authors);

        if (!$project->getClimate()) {
            unset($composer_config['require']['league/climate']);
            if (!isset($composer_config['require']) or !$composer_config['require']) {
                unset($composer_config['require']);
            }
        }

        // Remove bootstrapper namespace first...
        unset($composer_config['autoload']['psr-4']['FCA\\Bootstrapper\\']);
        if (!isset($composer_config['autoload']['psr-4']) or !$composer_config['autoload']['psr-4']) {
            unset($composer_config['autoload']['psr-4']);
        }
        if (!isset($composer_config['autoload']) or !$composer_config['autoload']) {
            unset($composer_config['autoload']);
        }
        // ... and the add PSR-4 namespace for current project
        if ($psr4namespace = $project->getPsr4namespace()) {
            if (!isset($composer_config['autoload']['psr-4'])) {
                if (!isset($composer_config['autoload'])) {
                    $composer_config['autoload'] = [
                        'psr-4' => [],
                    ];
                }
                $composer_config['autoload']['psr-4'][$psr4namespace] = 'src/classes/';
            }
        }
        unset($psr4namespace);
    }
}
