<?php
declare(strict_types=1);

namespace FCA\Bootstrapper\Bootstrap\Action;

use FCA\Bootstrapper\Bootstrap\Project;

class CreateReadme extends \FCA\Bootstrapper\Bootstrap\AbstractAction
{
    public function __invoke()
    {
        /** @var Project $project */
        $project = $this->container->get(Project::class);

        $readme = join(PHP_EOL, [
            $project->getDescription(),
            str_repeat('=', strlen($project->getDescription()))
        ]) . PHP_EOL;

        file_put_contents(BASE_PROJECT_DIRECTORY . '/README.md', $readme);
    }
}
