<?php
declare(strict_types=1);

namespace FCA\Bootstrapper\Bootstrap\Action;

use FCA\Bootstrapper\Bootstrap\Project;

class RuntimeConfiguration extends \FCA\Bootstrapper\Bootstrap\AbstractAction
{
    public function __invoke()
    {
        /** @var \League\CLImate\CLImate $climate */
        $climate = $this->container->get(\League\CLImate\CLImate::class);

        $runtimeConfiguration = new Project\RuntimeConfiguration();

        $input = $climate->lightGreen()->confirm(
            'Will this project run under Apache?'
        )->defaultTo('Y');

        if ($input->confirmed()) {
            $runtimeConfiguration->setApache(true);
        } else {
            $input = $climate->lightGreen()->confirm(
                'Will this project run under Nginx?'
            )->defaultTo('Y');
            $runtimeConfiguration->setNginx($input->confirmed());
        }

        $input = $climate->lightGreen()->confirm(
            'Will this project use PHP-FPM (despite HTTP server)?'
        )->defaultTo('Y');

        if ($input->confirmed()) {
            $runtimeConfiguration->setPhpFpm(true);
        } elseif ($runtimeConfiguration->isApache()) {
            $input = $climate->green()->confirm(
                'Will this project use Apache\'s PHP_MOD?'
            )->defaultTo('N');
            $runtimeConfiguration->setApachePhpMod($input->confirmed());
        }

        $input = $climate->lightGreen()->confirm(
            'Are you planning to use CLI within this application?'
        )->defaultTo('Y');
        $runtimeConfiguration->setPhpFpm($input->confirmed());

        /** @var Project $project */
        $project = $this->container->get(Project::class);
        $project->setRuntimeConfiguration($runtimeConfiguration);
    }
}
