<?php
declare(strict_types=1);

namespace FCA\Bootstrapper\Bootstrap\Service;

class ComposerConfig
{
    private string $filepath;

    private \ArrayObject $config;

    public function __construct(string $filepath)
    {
        $this->filepath = $filepath;
        $this->config = new \ArrayObject(json_decode(file_get_contents($this->filepath), true));
    }

    public function write(): void
    {
        file_put_contents(
            $this->filepath,
            json_encode($this->config->getArrayCopy(), JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES)
        );
    }

    public function __destruct()
    {
        $this->write();
    }

    public function getConfig(): \ArrayObject
    {
        return $this->config;
    }
}
