<?php
declare(strict_types=1);

namespace FCA\Bootstrapper\Bootstrap\Action;

use FCA\Bootstrapper\Bootstrap\Project;

class SetLicense extends \FCA\Bootstrapper\Bootstrap\AbstractAction
{
    public function __invoke()
    {
        /** @var \League\CLImate\CLImate $climate */
        $climate = $this->container->get(\League\CLImate\CLImate::class);

        $options = [
            'Apache-2.0',
            'BSD-2-Clause',
            'BSD-3-Clause',
            'BSD-4-Clause',
            'GPL-2.0-only / GPL-2.0-or-later',
            'GPL-3.0-only / GPL-3.0-or-later',
            'LGPL-2.1-only / LGPL-2.1-or-later',
            'LGPL-3.0-only / LGPL-3.0-or-later',
            'MIT',
            'proprietary',
        ];
        $input = $climate->lightGreen()->radio('Please choose a license:', $options);
        $response = $input->prompt();

        /** @var Project $project */
        $project = $this->container->get(Project::class);
        $project->setLicense($response);
    }
}
