<?php
declare(strict_types=1);

namespace FCA\Bootstrapper\Bootstrap\Action;

class UpdateFilePermissions extends \FCA\Bootstrapper\Bootstrap\AbstractAction
{
    public function __invoke()
    {
        $executables = [
            BASE_PROJECT_DIRECTORY . '/docker/composer.sh',
            BASE_PROJECT_DIRECTORY . '/docker/php.sh',
            BASE_PROJECT_DIRECTORY . '/docker/phpcs.sh',
            BASE_PROJECT_DIRECTORY . '/docker/phpstan.sh',
            BASE_PROJECT_DIRECTORY . '/docker/psalm.sh',
        ];

        $owner_execute = 0100;

        foreach ($executables as $executable) {
            if (file_exists($executable)) {
                $fileperms = fileperms($executable);
                if ($fileperms === false) {
                    continue;
                }
                if (($fileperms & $owner_execute) !== $owner_execute) {
                    // Add "u+x" to the shell scripts
                    chmod($executable, $fileperms | $owner_execute);
                }
            }
        }
    }
}
