<?php
declare(strict_types=1);

namespace FCA\Bootstrapper\Bootstrap;

class Flow
{
    private \League\CLImate\CLImate $climate;
    private \SplObjectStorage $actions;

    private string $actions_config_filepath;
    private string $dic_config_filepath;
    private string $bootstrap_executable;

    public function __construct(string $bootstrap_executable, string $actions_config, string $dic_config)
    {
        $this->actions_config_filepath = $actions_config;
        $this->dic_config_filepath = $dic_config;
        $this->bootstrap_executable = $bootstrap_executable;
        /** @var \Psr\Container\ContainerInterface $dic */
        $dic = require_once $dic_config;
        $this->climate = $dic->get(\League\CLImate\CLImate::class);
        $this->actions = new \SplObjectStorage();

        foreach (require_once $this->actions_config_filepath as $action_class) {
            if (!class_exists($action_class)) {
                throw new \RuntimeException('Class "' . $action_class . '" not found');
            }
            $action = new $action_class($dic);
            if (!($action instanceof AbstractAction)) {
                throw new \RuntimeException('Class "' . $action_class . '" must implement AbstractAction');
            }
            $this->actions->attach($action);
        }
    }

    public function run(): void
    {
        foreach ($this->actions as $action) {
            call_user_func($action);
        }
        $this->postRun();
    }

    private function postRun()
    {
        $this->climate->lightGreen()->out('[POSTRUN]');
        unlink($this->actions_config_filepath);
        unlink($this->dic_config_filepath);
        unlink($this->bootstrap_executable);
    }
}
