<?php
declare(strict_types=1);

namespace FCA\Bootstrapper\Bootstrap\Action;

use FCA\Bootstrapper\Bootstrap\Project;

class Climate extends \FCA\Bootstrapper\Bootstrap\AbstractAction
{
    public function __invoke()
    {
        /** @var \League\CLImate\CLImate $climate */
        $climate = $this->container->get(\League\CLImate\CLImate::class);

        $input = $climate->lightGreen()->confirm(
            'Would you like to use "league/climate" (CLI library) in your project?'
        )->defaultTo('N');

        if ($input->confirmed()) {
            /** @var Project $project */
            $project = $this->container->get(Project::class);
            $project->setClimate(true);
        }
    }
}
