<?php
declare(strict_types=1);

namespace FCA\Bootstrapper\Bootstrap\Action;

use FCA\Bootstrapper\Bootstrap\Project;

class CopyExampleFiles extends \FCA\Bootstrapper\Bootstrap\AbstractAction
{
    public function __invoke()
    {
        /** @var Project $project */
        $project = $this->container->get(Project::class);

        copy(
            BASE_PROJECT_DIRECTORY . '/docker/example.docker-compose.override.yml',
            BASE_PROJECT_DIRECTORY . '/docker-compose.override.yml',
        );
        copy(
            BASE_PROJECT_DIRECTORY . '/docker/example.env',
            BASE_PROJECT_DIRECTORY . '/.env',
        );
        copy(
            BASE_PROJECT_DIRECTORY . '/resources/example.settings.php',
            BASE_PROJECT_DIRECTORY . '/config/settings.php',
        );

        if ($project->getRuntimeConfiguration()->isApache()) {
            copy(
                BASE_PROJECT_DIRECTORY . '/resources/example.htaccess',
                BASE_PROJECT_DIRECTORY . '/public/.htaccess',
            );
        }

        if ($project->getRuntimeConfiguration()->isPhpFpm()) {
            copy(
                BASE_PROJECT_DIRECTORY . '/resources/example.user.ini',
                BASE_PROJECT_DIRECTORY . '/public/.user.ini',
            );
        }
    }
}
