<?php

namespace FCAPoland\DealerAPIHelper;

class Region
{
    public function __construct(
        private ?int $id = null,
        private ?string $code = null,
        private ?string $name = null,
    ) {
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getCode(): ?string
    {
        return $this->code;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public static function createFromArray(array $data): self
    {
        return new self(
            id: $data['id'] ?? null,
            code: $data['code'] ?? null,
            name: $data['name'] ?? null,
        );
    }
}
