<?php

namespace FCAPoland\DealerAPIHelper;

class Services
{
    public const SALES = 'sales';
    public const BODYSHOP = 'bodyshop';
    public const GARAGE = 'garage';
    public const SECONDHAND = 'secondhand';
    public const QUATTROC = 'quattroc';
    public const MOTABILITY = 'motability';
    public const FLEET_SPEC = 'fleet_spec';
    public const AUTO_EXPERT = 'auto_expert';
    public const SELECTED_FOR_YOU = 'selected_for_you';

    public function __construct(
        private ?bool $sales = null,
        private ?bool $bodyshop = null,
        private ?bool $garage = null,
        private ?bool $secondhand = null,
        private ?bool $quattroc = null,
        private ?bool $motability = null,
        private ?bool $fleet_spec = null,
        private ?bool $auto_expert = null,
        private ?bool $selected_for_you = null,
    ) {
    }

    public function hasSales(): ?bool
    {
        return $this->sales;
    }

    public function hasBodyshop(): ?bool
    {
        return $this->bodyshop;
    }

    public function hasGarage(): ?bool
    {
        return $this->garage;
    }

    public function hasSecondhand(): ?bool
    {
        return $this->secondhand;
    }

    public function hasQuattroc(): ?bool
    {
        return $this->quattroc;
    }

    public function hasMotability(): ?bool
    {
        return $this->motability;
    }

    public function hasFleetSpec(): ?bool
    {
        return $this->fleet_spec;
    }

    public function hasAutoExpert(): ?bool
    {
        return $this->auto_expert;
    }

    public function hasSelectedForYou(): ?bool
    {
        return $this->selected_for_you;
    }

    public static function createFromArray(array $data): self
    {
        return new self(
            sales: isset($data['sales']) ? (bool)$data['sales'] : null,
            bodyshop: isset($data['bodyshop']) ? (bool)$data['bodyshop'] : null,
            garage: isset($data['garage']) ? (bool)$data['garage'] : null,
            secondhand: isset($data['secondhand']) ? (bool)$data['secondhand'] : null,
            quattroc: isset($data['quattroc']) ? (bool)$data['quattroc'] : null,
            motability: isset($data['motability']) ? (bool)$data['motability'] : null,
            fleet_spec: isset($data['fleet_spec']) ? (bool)$data['fleet_spec'] : null,
            auto_expert: isset($data['auto_expert']) ? (bool)$data['auto_expert'] : null,
            selected_for_you: isset($data['selected_for_you']) ? (bool)$data['selected_for_you'] : null,
        );
    }
}
