<?php

namespace FCAPoland\DealerAPIHelper;

class Address
{
    private Region $region;

    public function __construct(
        private ?string $street = null,
        private ?string $post_code = null,
        private ?string $city = null,
        ?Region $region = null,
    ) {
        $this->region = $region ?? new Region();
    }

    public function getStreet(): ?string
    {
        return $this->street;
    }

    public function getPostCode(): ?string
    {
        return $this->post_code;
    }

    public function getCity(): ?string
    {
        return $this->city;
    }

    public function getRegion(): Region
    {
        return $this->region;
    }

    public static function createFromArray(array $data): self
    {
        return new self(
            street: $data['street'] ?? null,
            post_code: $data['post_code'] ?? null,
            city: $data['city'] ?? null,
            region: Region::createFromArray($data['region'] ?? []),
        );
    }
}
