<?php

namespace FCAPoland\DealerAPIHelper;

class Coordinates
{
    public function __construct(private ?float $latitude = null, private ?float $longitude = null)
    {
    }

    public function getLatitude(): ?float
    {
        return $this->latitude;
    }

    public function getLongitude(): ?float
    {
        return $this->longitude;
    }

    public static function createFromArray(array $data): self
    {
        return new self(
            latitude: isset($data['latitude']) ? (float)$data['latitude'] : null,
            longitude: isset($data['longitude']) ? (float)$data['longitude'] : null,
        );
    }
}
