<?php
require_once realpath(implode(DIRECTORY_SEPARATOR, [__DIR__, '..', 'vendor', 'autoload.php']));

echo <<<ASCIIART

  ____  _       _ _             _   _
 / ___|| |_ ___| | | __ _ _ __ | |_(_)___
 \___ \| __/ _ \ | |/ _` | '_ \| __| / __|
  ___) | ||  __/ | | (_| | | | | |_| \__ \
 |____/ \__\___|_|_|\__,_|_| |_|\__|_|___/


ASCIIART;

// One can override default API URL (which is https://api.fcapoland.pl/dealers) by defining one's own using
// `DEALER_API_URL` constant in one's own PHPUnit's `bootstrap.php` file and then including this bootstrap to
// proceed normally:
//
//     <?php // contents of `my_bootstrap.php`
//     define('DEALER_API_URL', 'http://localhost:8080');
//     require_once __DIR__ . '/tests/bootstrap.php';
//
// And then:
//
//     $ php ./vendor/bin/phpunit --bootstrap my_bootstrap.php
//
// or, if `test.sh` is availabe:
//
//     $ ./test.sh --bootstrap my_bootstrap.php
//
$tests_cache_dir = realpath(__DIR__ . '/../tmp') . '/testsCache';
if (!is_dir($tests_cache_dir)) {
    mkdir($tests_cache_dir);
}
define('CACHE_DIR', $tests_cache_dir);
define('BACKUP_FILENAME', realpath(__DIR__ . '/../tmp') . '/dealers-backup.json');
if (!defined('DEALER_API_URL')) {
    define('DEALER_API_URL', 'https://api.fcapoland.pl/dealers');
}
