<?php

namespace FCAPoland\DealerAPIHelper;

use FCAPoland\DealerAPIHelper\OpeningHours\Date;

class OpeningHours
{
    private const DATE_FORMAT = 'Y-m-d';

    /**
     * @var Date[]
     */
    private array $openingHours = [];

    public function __construct(Date ...$openingHours)
    {
        foreach ($openingHours as $openingHoursForDate) {
            $this->openingHours[$openingHoursForDate->getDate()->format(self::DATE_FORMAT)]
                = $openingHoursForDate;
        }
    }

    /**
     * @return Date[]
     */
    public function getAll(): array
    {
        return $this->openingHours;
    }

    public function forDate(string $date): ?Date
    {
        try {
            $date = new \DateTimeImmutable($date);
        } catch (\Exception) {
            return null;
        }

        foreach ($this->openingHours as $openingHoursForDate) {
            if ($openingHoursForDate->getDate()->format(self::DATE_FORMAT) === $date->format(self::DATE_FORMAT)) {
                return $openingHoursForDate;
            }
        }

        return null;
    }

    public static function createFromArray(array $openingHours): self
    {
        $for_constructor = [];
        foreach ($openingHours as $openingHoursForDate) {
            $for_constructor[] = new Date(
                date: isset($openingHoursForDate['date']) ? (string)$openingHoursForDate['date'] : null,
                weekday: isset($openingHoursForDate['weekday']) ? (string)$openingHoursForDate['weekday'] : null,
                open: isset($openingHoursForDate['open']) ? (bool)$openingHoursForDate['open'] : null,
                from: isset($openingHoursForDate['from']) ? (string)$openingHoursForDate['from'] : null,
                to: isset($openingHoursForDate['to']) ? (string)$openingHoursForDate['to'] : null,
            );
        }

        return new self(...$for_constructor);
    }
}
