<?php

namespace Tests\Unit;

use FCAPoland\DealerAPIHelper\DealerLoader;
use PHPUnit\Framework\TestCase;
use Tests\DealerLoaderFactory;
use Tests\Liberator;

class DealerLoaderTest extends TestCase
{
    public function testBackingUp(): void
    {
        $dealer_loader = DealerLoaderFactory::create();
        $backup_file = BACKUP_FILENAME;
        register_shutdown_function(function () use ($backup_file) {
            if (file_exists($backup_file)) {
                unlink($backup_file);
            }
        });
        $fp = fopen($backup_file, 'w+');
        $dealer_loader->setBackup($fp, 120);
        $dealers = $dealer_loader->fetch();
        rewind($fp);
        $date = fgets($fp); // First line is a backup creation date
        $this->assertNotFalse(strtotime($date));

        $this->assertEquals(stream_get_contents($fp), $dealers);
        fclose($fp);
        unlink($backup_file);
    }

    public function testSettingExtraFields(): void
    {
        $dealer_loader = DealerLoaderFactory::create();
        $dealer_loader->setExtraFields(['foo', 'bar']);

        $dealer_loader_liberated = new Liberator($dealer_loader);

        $this->assertArrayHasKey('extra_fields', $dealer_loader_liberated->query_params);
        // Note alphabetical order ↓:
        $this->assertEquals('bar,foo', $dealer_loader_liberated->query_params['extra_fields']);
    }

    public function testGetCacheKey(): void
    {
        $dealer_loader = new DealerLoader();
        $dealer_loader_liberated = new Liberator($dealer_loader);
        $this->assertEquals(
            'fca_dealer_api_json_' . md5($dealer_loader_liberated->dealer_api_url),
            $dealer_loader_liberated->getCacheKey()
        );
        $dealer_loader->setExtraFields(['foo', 'bar']);
        $suffix = md5(serialize(['extra_fields' => 'bar,foo'])); // Note alphabetical sorting
        $this->assertEquals(
            'fca_dealer_api_json_'  . md5($dealer_loader_liberated->dealer_api_url) . '_' . $suffix,
            $dealer_loader_liberated->getCacheKey()
        );
    }
}
