Dealer API Helper
=================

Library to help and standarize the way Dealer API (https://api.fcapoland.pl/dealers) 
is accessed and worked with within PHP projects.

Simple usage by example:

1. Include the library in your project:

   `$ composer require fca-poland/dealer-api-helper`

2. Use it:
    ```php
    <?php
    require_once "vendor/autoload.php";

    $dealers = new \FCAPoland\DealerAPIHelper\Dealers();
    $dealers = $dealers
        ->withSINCOMs(['0075417.000'])
        ->withBrands(['00'])
        ->includeOpeningHours()
        ->get();

    foreach ($dealers as $dealer) {
        /** @var \FCAPoland\DealerAPIHelper\Dealer $dealer */
        echo $dealer->getSINCOM();
        echo PHP_EOL;
    }
    ```

Development
-----------

1. Instal development dependencies:

    `$ composer install --dev`

2. Checkout to development branch:

    `$ git checkout -b dev/feature-1`

3. Do the development (remember about tests!)
4. Sniff the code and detect mess:

    ```
    $ ./sniff-the-code.sh
    $ ./detect-mess.sh
    ```
5. Test:

    `$ ./test.sh`

   Note that one can override default API URL (which is `https://api.fcapoland.pl/dealers`) by defining one's own using
   `DEALER_API_URL` constant in custom PHPUnit's `bootstrap.php` file and then calling project's bootstrap to proceed 
   normally (i.e. saving other bootstraped settings):

   ```php
   <?php // contents of `my_bootstrap.php`
   define('DEALER_API_URL', 'http://localhost:8080');
   require_once __DIR__ . '/tests/bootstrap.php';
   ```

   And then:

       $ php ./vendor/bin/phpunit --bootstrap my_bootstrap.php

   or, if `test.sh` is availabe:

       $ ./test.sh --bootstrap my_bootstrap.php

6. Merge or create merge request.
7. Be happy PHP developer!


Docker
------

To run tests against different PHP versions follow examples below (execute from library's root directory):

 - PHP 5.6:

    ```shell
    $ docker run -it --rm --name stellantis-dealer-api-helper-tests --user "$(id -u):$(id -g)" -v "$PWD":/app -w /app php:MAJOR.MINOR.PATCH-cli php ./vendor/bin/phpunit
    ```

### Updating (managing) Composer dependencies

When trying to update library dependencies use following `Dockerfile` example to create temporary image
for container with PHP 5.6, required extensions and `composer.phar`:

```Dockerfile
FROM php:MAJOR.MINOR.PATCH-cli
WORKDIR /usr/src/myapp
COPY --from=mlocati/php-extension-installer /usr/bin/install-php-extensions /usr/local/bin/
RUN install-php-extensions curl json zip
COPY --from=composer /usr/bin/composer /usr/bin/composer
```

Then use the image to run container and update the dependencies, like in this example:

```shell
$ docker run \
    -it \
    --rm \
    --name stellantis-dealer-api-helper-composer \
    --user "$(id -u):$(id -g)" \
    -v "$PWD":/app \
    -w /app \
    --volume ${COMPOSER_HOME:-$HOME/.composer}:/tmp \
    php:MAJOR.MINOR.PATCH-cli \
    php composer.phar require --dev squizlabs/php_codesniffer
```
