<?php

namespace FCAPoland\DealerAPIHelper;

use Psr\SimpleCache\CacheInterface;

/**
 * Class MemoryCache
 *
 * Simple in-memory cache pool mainly for testing purposes.
 * It is flushed at the end of the script.
 *
 * @package FCAPoland\DealerAPIHelper
 * @psalm-api
 */
final class MemoryCache implements CacheInterface
{
    public function __construct(private array $storage = [])
    {
    }

    public function get(string $key, mixed $default = null): mixed
    {
        if (array_key_exists(key: $key, array: $this->storage)) {
            return $this->storage[$key];
        }

        return $default;
    }

    public function getMultiple(iterable $keys, mixed $default = null): iterable
    {
        $multiple = [];
        foreach ($keys as $key) {
            $multiple[$key] = $this->get(key: $key);
        }

        return $multiple;
    }

    public function has(string $key): bool
    {
        return array_key_exists(key: $key, array: $this->storage);
    }

    public function clear(): bool
    {
        $this->storage = [];

        return true;
    }

    public function delete(string $key): bool
    {
        unset($this->storage[$key]);

        return true;
    }

    public function deleteMultiple(iterable $keys): bool
    {
        foreach ($keys as $key) {
            $this->delete(key: $key);
        }

        return true;
    }

    public function set(string $key, mixed $value, null|int|\DateInterval $ttl = null): bool
    {
        $this->storage[$key] = $value;

        return true;
    }

    public function setMultiple(iterable $values, null|int|\DateInterval $ttl = null): bool
    {
        foreach ($values as $key => $value) {
            $this->set(key: $key, value: $value, ttl: $ttl);
        }

        return true;
    }
}
