<?php

namespace FCAPoland\DealerAPIHelper\OpeningHours;

class Date
{
    public function __construct(
        private string $date,
        private string $weekday,
        private bool $open,
        private string $from,
        private string $to,
    ) {
    }

    public function getDate(): \DateTimeImmutable
    {
        return new \DateTimeImmutable($this->date);
    }

    public function getWeekday(): string
    {
        return $this->weekday;
    }

    public function isOpen(): bool
    {
        return $this->open;
    }

    public function getFrom(): string
    {
        return $this->from;
    }

    public function getTo(): string
    {
        return $this->to;
    }
}
