<?php

namespace FCAPoland\APIHelper;

use Psr\Log\LoggerInterface;
use Psr\Log\NullLogger;

class DealerLoader
{
    private $dealer_api_url = 'https://api.fcapoland.pl/dealers/:SINCOMS:';

    private $logger;

    private $filters = [
        'sincoms' => [],
        'types'   => [],
        'brands'  => [],
    ];

    public function __construct(LoggerInterface $logger = null)
    {
        $this->logger = $logger ? $logger : new NullLogger();
    }

    public function setFilters(array $filters)
    {
        $this->filters = array_replace($this->filters, array_intersect_key($filters, $this->filters));
    }

    public function fetch()
    {
        $dealers = '';
        try {
            $query_params = [
                'types'        => join(',', $this->filters['types']),
                'brands'       => join(',', $this->filters['brands']),
                'extra_fields' => 'services,rz,opening_hours',
            ];

            $url = strtr(
                $this->dealer_api_url,
                [
                    ':SINCOMS:' => urlencode(join(',', $this->filters['sincoms'])),
                ]
            ) . '?' . http_build_query(array_filter($query_params));

            $curl_handle = curl_init();
            curl_setopt($curl_handle, CURLOPT_URL, $url);
            curl_setopt($curl_handle, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($curl_handle, CURLOPT_HEADER, false);
            curl_setopt($curl_handle, CURLOPT_HTTPHEADER, ['Cache-Control: no-cache', 'Pragma: no-cache']);
            $dealers = curl_exec($curl_handle);
            curl_close($curl_handle);

//            if (!$dealers) {
            // TODO: load from backup file/cache
//            } else {
            // TODO: store to backup file/cache but only once a while
//            }
        } catch (\Exception $e) {
            // TODO: load from backup file/cache
            $this->logger->error($e->getMessage());
        }

        return $dealers;
    }

    /**
     * @param string $url
     */
    public function setDealerAPIUrl($url)
    {
        $this->dealer_api_url = $url;
    }
}
