<?php

namespace Tests\Unit;

use FCAPoland\APIHelper\DealerLoader;

class DealerLoaderTest extends \PHPUnit_Framework_TestCase
{
    public function testSetFilters()
    {
        $dealer_loader = new DealerLoader();
        $filters = $input = [
            'sincoms' => ['0075440.001'],
            'brands'  => ['83'],
            'types'   => ['aftersales'],
        ];

        $dealer_loader->setFilters($input);
        $this->assertAttributeEquals($filters, 'filters', $dealer_loader);
        unset($filters, $input, $dealer_loader);

        $dealer_loader = new DealerLoader();
        $filters = $input = [
            'sincoms' => ['0075440.001', '0075631.000'],
            'brands'  => ['83', '00'],
            'types'   => ['aftersales', 'sales'],
        ];

        $dealer_loader->setFilters($input);
        $this->assertAttributeEquals($filters, 'filters', $dealer_loader);
    }
}
