<?php

namespace Tests\Unit;

use FCAPoland\APIHelper\MemoryCache;
use FCAPoland\APIHelper\DealerLoader;

class DealerLoaderTest extends \PHPUnit_Framework_TestCase
{
    public function testCaching()
    {
        $dealer_loader = new DealerLoader();
        $the_cache = [];
        $pool = new MemoryCache\ItemPool($the_cache);
        $dealer_loader->setCache($pool, 60);
        $dealer_loader->fetch();

        $class = new \ReflectionClass($dealer_loader);
        $property = $class->getProperty('cache_key');
        $property->setAccessible(true);
        $cache_item_key = $property->getValue($dealer_loader);
        $this->assertCount(1, $the_cache);
        $this->assertArrayHasKey($cache_item_key, $the_cache);
    }

    public function testBackingUp()
    {
        $dealer_loader = new DealerLoader();
        $tmp_file = tempnam(sys_get_temp_dir(), 'fca_dealer_api_helper_tmp_');
        $fp = fopen($tmp_file, 'r+');
        $dealer_loader->setBackup($fp, 120);
        $dealers = $dealer_loader->fetch();

        rewind($fp);
        $date = fgets($fp); // First line is a backup creation date
        $this->assertNotFalse(strtotime($date));

        $this->assertEquals(stream_get_contents($fp), $dealers);
        fclose($fp);
        unlink($tmp_file);
    }
}
