<?php
require_once realpath(join(DIRECTORY_SEPARATOR, [__DIR__, '..', 'vendor', 'autoload.php']));

$ascii = <<<ASCIIART
   ____________     ___  ____  __   ___   _  _____ 
  / __/ ___/ _ |   / _ \/ __ \/ /  / _ | / |/ / _ \
 / _// /__/ __ |  / ___/ /_/ / /__/ __ |/    / // /
/_/  \___/_/ |_| /_/   \____/____/_/ |_/_/|_/____/
ASCIIART;

// One can override default API URL (which is https://api.fcapoland.pl/dealers) by defining one's own using
// `DEALER_API_URL` constant in one's own PHPUnit's `bootstrap.php` file and then including this bootstrap to
// proceed normally:
//
//     <?php // contents of `my_bootstrap.php`
//     define('DEALER_API_URL', 'http://localhost:8080');
//     require_once __DIR__ . '/tests/bootstrap.php';
//
// And then:
//
//     $ php ./vendor/bin/phpunit --bootstrap my_bootstrap.php
//
// or, if `test.sh` is availabe:
//
//     $ ./test.sh --bootstrap my_bootstrap.php
//
if (!defined('DEALER_API_URL')) {
    define('DEALER_API_URL', 'https://api.fcapoland.pl/dealers');
}

echo $ascii . PHP_EOL . PHP_EOL;
unset($ascii);
