<?php
namespace FCAPoland\DWS\DealerAuthHelper;

use FCAPoland\DWS\DealerAuthHelper\App\Database;
use FCAPoland\DWS\DealerAuthHelper\App\Dealer;

/**
 * Created by PhpStorm.
 * User: Damian Banaszkiewicz <dbanaszkiewicz@unicorn.net.pl>
 * Date: 18.04.18 12:21
 */

class DealerAuthHelper
{
    /**
     * @var $db \PDO
     */
    private $db = null;

    /**
     * @param string $hostname
     * @param string $database
     * @param string $username
     * @param string $password
     * @param string|int $port
     * @param string $charset
     */
    public function openDbConnection($hostname, $database, $username, $password, $port, $charset = 'utf8')
    {
        $db = new Database();
        $db->setParams($hostname, $database, $username, $password, $port, $charset);

        $this->db = $db->getDBHandler();
    }

    /**
     * Metoda zwracająca tablicę z danymi dealera, lub null - gdy dane do logowania są niepoprawne
     * @param $name
     * @param $password
     * @return Dealer
     */
    public function getDealerData($name, $password) {
        $statement = $this->fetchDealer($name);

        if ($statement->rowCount() > 0) {
            $dealer_auth = $statement->fetchObject();

            if ($this->isPasswordValid($password, $dealer_auth)) {
                return new Dealer(
                    str_pad($dealer_auth->dealer, 7, '0', STR_PAD_LEFT),
                    $dealer_auth->nazwa,
                    (($dealer_auth->haslo_tymczasowe === '1') ? true : false),
                    strtotime($dealer_auth->data_waznosci)
                );
            }
        }

        return null;
    }

    public function accountExists($name)
    {
        $statement = $this->fetchDealer($name);

        return $statement->rowCount() === 1;
    }

    private function fetchDealer($name)
    {
        $statement = $this->db->prepare('SELECT * FROM v_autoryzacja WHERE nazwa=?');
        $statement->bindParam(1, $name, \PDO::PARAM_STR);
        $statement->execute();

        return $statement;
    }

    /**
     * @param string $password
     * @param object $dealer
     * @return bool
     */
    private function isPasswordValid($password, $dealer)
    {
        $hash = crypt($password, $dealer->haslo);
        return $hash === $dealer->haslo;
    }

//    private function getPassHash($password) {
//        $salt = '$6$';
//        do {
//            $salt_zn = chr(rand(33, 122));
//            if (preg_match('@[a-zA-Z0-9./]@', $salt_zn)) {
//                $salt .= $salt_zn;
//            }
//        } while (strlen($salt) < 19);
//
//        $haslo_k = crypt($password, $salt);
//
//        return $haslo_k;
//    }
}
