<?php

namespace FCAPoland\FinancialAPI;

use Exception;
use FCAPoland\FinancialAPI\Model\CalculateResponseData;
use FCAPoland\FinancialAPI\Model\DetectResponseData;
use FCAPoland\FinancialAPI\Model\RequestData;
use GuzzleHttp\Exception\GuzzleException;

class FinancialAPI
{
    /**
     * @var RequestClient
     */
    private $requestClient;

    public function __construct(Config $config = null)
    {
        if (is_null($config)) {
            $config = new Config();
        }

        $this->requestClient = new RequestClient\HTTP($config);
    }

    /**
     * @param RequestData $requestData
     * @return DetectResponseData
     * @throws GuzzleException
     * @throws Exception
     */
    public function detectStockCalculators(RequestData $requestData): DetectResponseData
    {
        return $this->requestClient->detectStockCalculators($requestData);
    }

    /**
     * @param RequestData $requestData
     * @param string $calculatorName
     * @return CalculateResponseData
     * @throws GuzzleException
     * @throws Exception
     */
    public function calculate(RequestData $requestData, string $calculatorName): CalculateResponseData
    {
        return $this->requestClient->calculate($requestData, $calculatorName);
    }
}
