<?php

namespace FCAPoland\FinancialAPI\Model\Response\Calculation;

class AvailableFields
{
    /**
     * @var array
     */
    protected $period;

    /**
     * @var array
     */
    protected $contribution;

    /**
     * @var array
     */
    protected $repurchase;

    /**
     * @var array
     */
    protected $limitKm;

    /**
     * @var array
     */
    protected $balloonRate;

    protected $fieldsList = [
        'period',
        'contribution',
        'repurchase',
        'limitKm',
        'balloonRate'
    ];

    public function __construct(array $dataArray)
    {
        foreach ($dataArray as $key => $value) {
            if (in_array($key, $this->fieldsList)) {
                $this->$key = $value;
            } else {
                throw new \InvalidArgumentException("Key [" . $key . "] is not acceptable for " . self::class);
            }
        }
    }

    public function toArray(): array
    {
        $array = [];

        foreach ($this->fieldsList as $field) {
            if (isset($this->$field)) {
                $array[$field] = $this->$field;
            }
        }

        return $array;
    }

    /**
     * @return array
     */
    public function getPeriod(): array
    {
        return $this->period;
    }

    /**
     * @return array
     */
    public function getContribution(): array
    {
        return $this->contribution;
    }

    /**
     * @return array
     */
    public function getRepurchase(): array
    {
        return $this->repurchase;
    }

    /**
     * @return array
     */
    public function getLimitKm(): array
    {
        return $this->limitKm;
    }

    /**
     * @return array
     */
    public function getBalloonRate(): array
    {
        return $this->balloonRate;
    }
}
