<?php

namespace FCAPoland\FinancialAPI\Model\Request;

class Vehicle
{
    /**
     * @var string
     */
    protected $brand;

    /**
     * @var string
     */
    protected $modelCode;

    /**
     * @var string
     */
    protected $modelName;

    /**
     * @var int
     */
    protected $productionYear;

    /**
     * @var string
     */
    protected $productionDate;

    /**
     * @var float
     */
    protected $netPrice;

    /**
     * @var float
     */
    protected $grossPrice;

    /**
     * @var bool
     */
    protected $isKm0;

    /**
     * @var string
     */
    protected $versionId;

    /**
     * @var string
     */
    protected $versionName;

    /**
     * @var bool
     */
    protected $isElectric;

    /**
     * @var array
     */
    protected $labels;

    protected $fieldsList = [
        'brand',
        'modelCode',
        'modelName',
        'productionYear',
        'productionDate',
        'netPrice',
        'grossPrice',
        'isKm0',
        'versionId',
        'versionName',
        'isElectric',
        'labels',
    ];

    public function __construct(array $dataArray = [])
    {
        foreach ($dataArray as $key => $value) {
            if (in_array($key, $this->fieldsList)) {
                $this->$key = $value;
            } else {
                throw new \InvalidArgumentException("Key [" . $key . "] is not acceptable for " . self::class);
            }
        }
    }

    public function toArray(): array
    {
        $array = [];

        foreach ($this->fieldsList as $field) {
            if (isset($this->$field)) {
                $array[$field] = $this->$field;
            }
        }

        return $array;
    }

    /**
     * @return string
     */
    public function getBrand(): string
    {
        return $this->brand;
    }

    /**
     * @param string $brand
     */
    public function setBrand(string $brand): self
    {
        $this->brand = $brand;
        return $this;
    }

    /**
     * @return string
     */
    public function getModelCode(): string
    {
        return $this->modelCode;
    }

    /**
     * @param string $modelCode
     */
    public function setModelCode(string $modelCode): self
    {
        $this->modelCode = $modelCode;
        return $this;
    }

    /**
     * @return string
     */
    public function getModelName(): string
    {
        return $this->modelName;
    }

    /**
     * @param string $modelName
     */
    public function setModelName(string $modelName): self
    {
        $this->modelName = $modelName;
        return $this;
    }

    /**
     * @return int
     */
    public function getProductionYear(): int
    {
        return $this->productionYear;
    }

    /**
     * @param int $productionYear
     */
    public function setProductionYear(int $productionYear): self
    {
        $this->productionYear = $productionYear;
        return $this;
    }

    /**
     * @return string
     */
    public function getProductionDate(): string
    {
        return $this->productionDate;
    }

    /**
     * @param string $productionDate
     */
    public function setProductionDate(string $productionDate): self
    {
        $this->productionDate = $productionDate;
        return $this;
    }

    /**
     * @return float
     */
    public function getNetPrice(): float
    {
        return $this->netPrice;
    }

    /**
     * @param float $netPrice
     */
    public function setNetPrice(float $netPrice): self
    {
        $this->netPrice = $netPrice;
        return $this;
    }

    /**
     * @return float
     */
    public function getGrossPrice(): float
    {
        return $this->grossPrice;
    }

    /**
     * @param float $grossPrice
     */
    public function setGrossPrice(float $grossPrice): self
    {
        $this->grossPrice = $grossPrice;
        return $this;
    }

    /**
     * @return bool
     */
    public function isKm0(): bool
    {
        return $this->isKm0;
    }

    /**
     * @param bool $isKm0
     */
    public function setIsKm0(bool $isKm0): self
    {
        $this->isKm0 = $isKm0;
        return $this;
    }

    /**
     * @return string
     */
    public function getVersionId(): string
    {
        return $this->versionId;
    }

    /**
     * @param string $versionId
     */
    public function setVersionId(string $versionId): self
    {
        $this->versionId = $versionId;
        return $this;
    }

    /**
     * @return string
     */
    public function getVersionName(): string
    {
        return $this->versionName;
    }

    /**
     * @param string $versionName
     */
    public function setVersionName(string $versionName): self
    {
        $this->versionName = $versionName;
        return $this;
    }

    /**
     * @return bool
     */
    public function isElectric(): bool
    {
        return $this->isElectric;
    }

    /**
     * @param bool $isElectric
     */
    public function setIsElectric(bool $isElectric): self
    {
        $this->isElectric = $isElectric;
        return $this;
    }

    /**
     * @return array
     */
    public function getLabels(): array
    {
        return $this->labels;
    }

    /**
     * @param array $labels
     */
    public function setLabels(array $labels): self
    {
        $this->labels = $labels;
        return $this;
    }
}
