<?php

namespace FCAPoland\FinancialAPI\Model\Response\Calculation;

use FCAPoland\FinancialAPI\Model\Request\Fields;
use FCAPoland\FinancialAPI\Model\Response\Calculation\CurrentField\CurrentField;

class CurrentFields
{
    /**
     * @var CurrentField
     */
    protected $period;

    /**
     * @var CurrentField
     */
    protected $contribution;

    /**
     * @var CurrentField
     */
    protected $repurchase;

    /**
     * @var CurrentField
     */
    protected $limitKm;

    /**
     * @var CurrentField
     */
    protected $balloonRate;

    protected $fieldsList = [];

    public function __construct(array $dataArray)
    {
        foreach ($dataArray as $key => $value) {
            if (in_array($key, Fields::SUPPORTED_FIELDS_LIST)) {
                $this->fieldsList[] = $key;
                $this->$key = new CurrentField($value);
            } else {
                throw new \InvalidArgumentException("Key [" . $key . "] is not acceptable for " . self::class);
            }
        }
    }

    public function toArray(): array
    {
        $array = [];

        foreach ($this->fieldsList as $field) {
            if (isset($this->$field)) {
                $array[$field] = $this->$field->toArray();
            }
        }

        return $array;
    }

    /**
     * @return CurrentField
     */
    public function getPeriod(): CurrentField
    {
        return $this->period;
    }

    /**
     * @return CurrentField
     */
    public function getContribution(): CurrentField
    {
        return $this->contribution;
    }

    /**
     * @return CurrentField
     */
    public function getRepurchase(): CurrentField
    {
        return $this->repurchase;
    }

    /**
     * @return CurrentField
     */
    public function getLimitKm(): CurrentField
    {
        return $this->limitKm;
    }

    /**
     * @return CurrentField
     */
    public function getBalloonRate(): CurrentField
    {
        return $this->balloonRate;
    }
}
