<?php

namespace FCAPoland\FinancialAPI\Model\Response;

use FCAPoland\FinancialAPI\Model\Response\Detection\FinancialProduct;

class Detection
{
    /**
     * @var FinancialProduct[]
     */
    protected $credit = [];

    /**
     * @var FinancialProduct[]
     */
    protected $leasing = [];

    protected $fieldsList = [
        'credit',
        'leasing'
    ];

    public function __construct(array $dataArray)
    {
        foreach ($dataArray as $key => $value) {
            switch ($key) {
                case 'credit':
                    foreach ($value as $data) {
                        $this->credit[] = new FinancialProduct($data['name'], $data['calculation']);
                    }
                    break;
                case 'leasing':
                    foreach ($value as $data) {
                        $this->leasing[] = new FinancialProduct($data['name'], $data['calculation']);
                    }
                    break;
                default:
                    throw new \InvalidArgumentException("Key [" . $key . "] is not acceptable for " . self::class);
            }
        }
    }

    public function toArray(): array
    {
        $array = [];

        foreach ($this->fieldsList as $field) {
            if (isset($this->$field)) {
                $array[$field] = $this->$field;
            }
        }

        return $array;
    }

    /**
     * @return array|FinancialProduct[]
     */
    public function getCredit(): array
    {
        return $this->credit;
    }

    /**
     * @return FinancialProduct
     */
    public function getFirstCredit(): FinancialProduct
    {
        return $this->credit[0];
    }

    /**
     * @return array|FinancialProduct[]
     */
    public function getLeasing(): array
    {
        return $this->leasing;
    }

    /**
     * @return FinancialProduct
     */
    public function getFirstLeasing(): FinancialProduct
    {
        return $this->leasing[0];
    }
}
