<?php

namespace FCAPoland\FinancialAPI\Model\Response\Detection;

use FCAPoland\FinancialAPI\Model\Response\Calculation;

class FinancialProduct
{
    /**
     * @var string
     */
    protected $name;

    /**
     * @var Calculation
     */
    protected $calculation;

    public function __construct(string $name, array $calculation)
    {
        $this->name = $name;
        $this->calculation = new Calculation($calculation);
    }

    public function toArray(): array
    {
        return [
            'name' => $this->name,
            'calculation' => $this->calculation->toArray()
        ];
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @return Calculation
     */
    public function getCalculation(): Calculation
    {
        return $this->calculation;
    }
}
