# Financial Calculations API Library

A library that allows you to communicate with Financial Calculations API

# Examples

### Creating Vehicle object:

```php
$vehicle = (new \FCAPoland\FinancialAPI\Model\Request\Vehicle())
    ->setBrand('00')
    ->setModelName('500X')
    ->setProductionYear(2019)
    ->setNetPrice(122221)
    ->setGrossPrice(142221)
    ->setIsKm0(false)
    ->setVersionId('003313311000')
    ->setVersionName('VERSION_NAME')
    ->setLabels([])
    ->setIsElectric(false);
```

### Creating RequestData object:

```php
$requestData = new \FCAPoland\FinancialAPI\Model\RequestData();
$requestData->addVehicle('1', $vehicle);
```

### Creating FinancialAPI object:

```php
$config = new \FCAPoland\FinancialAPI\Config();
$config->setHttpApiUrl('https://api.fcapoland.pl/financial-calculations/');

$financialApi = new \FCAPoland\FinancialAPI\FinancialAPI($config);
```

### Detect Stock Calculators
```php
$detectedCalculators = $financialApi->detectStockCalculators($requestData);
```


### Product Calculation
```php
$productCalculation = $financialApi->calculate($requestData, 'credit-099');
```


