<?php

namespace FCAPoland\FinancialAPI\Model;

use FCAPoland\FinancialAPI\Model\Response\Calculation;
use FCAPoland\FinancialAPI\Model\Response\Detection;

class DetectResponseData
{
    /**
     * @var array
     */
    private $vehicleDetections = [];

    /**
     * @param array $data
     */
    public function __construct(array $data)
    {
        foreach ($data as $vehicleId => $detectionData) {
            $calculation = new Detection($detectionData);
            $this->vehicleDetections[$vehicleId] = $calculation;
        }
    }

    /**
     * @param string $vehicleId
     * @return Calculation
     */
    public function getDetectionByVehicleId(string $vehicleId): Detection
    {
        if (isset($this->vehicleDetections[$vehicleId])) {
            return $this->vehicleDetections[$vehicleId];
        }
        throw new \InvalidArgumentException('Vehicle with id [' . $vehicleId . '] was not send to calculation');
    }

    /**
     * @param bool $asArray
     * @return array
     */
    public function getAllDetections(bool $asArray = false): array
    {
        if ($asArray) {
            $array = [];

            foreach ($this->vehicleDetections as $vehicleId => $calculation) {
                $array[$vehicleId] = $calculation->toArray();
            }

            return $array;
        }

        return $this->vehicleDetections;
    }
}
