<?php

namespace FCAPoland\FinancialAPI\Model;

use Exception;
use FCAPoland\FinancialAPI\Model\Request\Fields;
use FCAPoland\FinancialAPI\Model\Request\Vehicle;

class RequestData
{
    private $data = [];

    private $withSolData = false;

    /**
     * @param string $vehicleId
     * @param Vehicle $vehicle
     * @param Fields|null $fields
     * @return $this
     * @throws Exception
     */
    public function addVehicle(string $vehicleId, Vehicle $vehicle, ?Fields $fields = null, $withSolData = false): self
    {
        if (isset($this->data[$vehicleId])) {
            throw new Exception('Object with the same vehicleId already exists (' . $vehicleId . ')');
        }

        $this->data[$vehicleId] = [
            'vehicle' => $vehicle,
            'fields' => $fields
        ];

        $this->withSolData = $withSolData;

        return $this;
    }

    /**
     * @return array
     */
    public function getVehicles(): array
    {
        return $this->data;
    }

    /**
     * @return bool
     */
    public function isWithSolData(): bool
    {
        return $this->withSolData;
    }

    /**
     * @return array
     */
    public function toArray(): array
    {
        $array = [];

        foreach ($this->data as $key => $value) {
            if (isset($value['fields'])) {
                $array[$key] = [
                    'vehicle' => $value['vehicle']->toArray(),
                    'fields' => $value['fields']->toArray()
                ];
            } else {
                $array[$key] = [
                    'vehicle' => $value['vehicle']->toArray(),
                ];
            }
        }

        return $array;
    }
}
