<?php

namespace FCAPoland\FinancialAPI\Model\Response;

use FCAPoland\FinancialAPI\Model\Response\Calculation\AvailableFields;
use FCAPoland\FinancialAPI\Model\Response\Calculation\CurrentFields;

class Calculation
{
    /**
     * @var string
     */
    protected $title;

    /**
     * @var string
     */
    protected $note;

    /**
     * @var float
     */
    protected $installment;

    /**
     * @var string
     */
    protected $priceType;

    /**
     * @var string
     */
    protected $provider;

    /**
     * @var CurrentFields
     */
    protected $currentFields;

    /**
     * @var AvailableFields
     */
    protected $availableFields;

    /**
     * @var array
     */
    protected $orderFields = [];

    /**
     * @var bool
     */
    protected $error;

    /**
     * @var string
     */
    protected $message;

    /**
     * @var array
     */
    protected $solParams = [];

    protected $fieldsList = [
        'title',
        'note',
        'installment',
        'priceType',
        'provider',
        'currentFields',
        'availableFields',
        'orderFields',
        'error',
        'message',
        'solParams'
    ];

    public function __construct(array $dataArray)
    {
        foreach ($dataArray as $key => $value) {
            if (in_array($key, $this->fieldsList)) {
                switch ($key) {
                    case 'currentFields':
                        $this->$key = new CurrentFields($value);
                        break;
                    case 'availableFields':
                        $this->$key = new AvailableFields($value);
                        break;
                    default:
                        $this->$key = $value;
                }
            }
        }
    }

    public function toArray(): array
    {
        $array = [];

        foreach ($this->fieldsList as $field) {
            if (isset($this->$field)) {
                switch ($field) {
                    case 'currentFields':
                    case 'availableFields':
                        $array[$field] = $this->$field->toArray($this->getOrderFields());
                        break;
                    default:
                        $array[$field] = $this->$field;
                }
            }
        }

        return $array;
    }

    /**
     * @return string
     */
    public function getTitle(): string
    {
        return $this->title;
    }

    /**
     * @return string
     */
    public function getNote(): string
    {
        return $this->note;
    }

    /**
     * @return float
     */
    public function getInstallment(): float
    {
        return $this->installment;
    }

    /**
     * @return string
     */
    public function getPriceType(): string
    {
        return $this->priceType;
    }

    /**
     * @return string
     */
    public function getProvider(): string
    {
        return $this->provider;
    }

    /**
     * @return CurrentFields
     */
    public function getCurrentFields(): CurrentFields
    {
        return $this->currentFields;
    }

    /**
     * @return AvailableFields
     */
    public function getAvailableFields(): AvailableFields
    {
        return $this->availableFields;
    }

    /**
     * @return array
     */
    public function getOrderFields(): array
    {
        return $this->orderFields;
    }

    /**
     * @return bool
     */
    public function isError(): bool
    {
        return $this->error;
    }

    /**
     * @return string
     */
    public function getMessage(): string
    {
        return $this->message;
    }

    /**
     * @return array
     */
    public function getSolParams(): array
    {
        return $this->solParams;
    }
}
