<?php

namespace FCAPoland\FinancialAPI\Model\Response\Calculation;

use FCAPoland\FinancialAPI\Model\Request\Fields;

class AvailableFields
{
    /**
     * @var array
     */
    protected $period;

    /**
     * @var array
     */
    protected $contribution;

    /**
     * @var array
     */
    protected $repurchase;

    /**
     * @var array
     */
    protected $limitKm;

    /**
     * @var array
     */
    protected $balloonRate;

    protected $fieldsList = [];

    public function __construct(array $dataArray)
    {
        foreach ($dataArray as $key => $value) {
            if (in_array($key, Fields::SUPPORTED_FIELDS_LIST)) {
                $this->fieldsList[] = $key;
                $this->$key = $value;
            } else {
                throw new \InvalidArgumentException("Key [" . $key . "] is not acceptable for " . self::class);
            }
        }
    }

    public function toArray($orderList = []): array
    {
        $array = [];

        foreach ($this->fieldsList as $field) {
            if (isset($this->$field)) {
                $array[$field] = $this->$field;
            }
        }

        // return sorted array
        return array_merge(array_flip(array_intersect($orderList, $this->fieldsList)), $array);
    }

    /**
     * @return array
     */
    public function getPeriod(): array
    {
        return $this->period;
    }

    /**
     * @return array
     */
    public function getContribution(): array
    {
        return $this->contribution;
    }

    /**
     * @return array
     */
    public function getRepurchase(): array
    {
        return $this->repurchase;
    }

    /**
     * @return array
     */
    public function getLimitKm(): array
    {
        return $this->limitKm;
    }

    /**
     * @return array
     */
    public function getBalloonRate(): array
    {
        return $this->balloonRate;
    }
}
