<?php

namespace FCAPoland\FinancialAPI;

use FCAPoland\FinancialAPI\Model\CalculateResponseData;
use FCAPoland\FinancialAPI\Model\DetectResponseData;
use FCAPoland\FinancialAPI\Model\RequestData;

interface RequestClient
{
    /**
     * @param RequestData $requestData
     * @return DetectResponseData
     */
    public function detectStockCalculators(RequestData $requestData): DetectResponseData;

    /**
     * @param RequestData $requestData
     * @param string $calculatorName
     * @return CalculateResponseData
     */
    public function calculate(RequestData $requestData, string $calculatorName): CalculateResponseData;
}
