<?php

namespace FCAPoland\FinancialAPI\Model\Request;

class Fields
{
    const SUPPORTED_FIELDS_LIST = [
        'period',
        'contribution',
        'repurchase',
        'limitKm',
        'balloonRate'
    ];

    /**
     * @var float
     */
    protected $period;

    /**
     * @var float
     */
    protected $contribution;

    /**
     * @var float
     */
    protected $repurchase;

    /**
     * @var float
     */
    protected $limitKm;

    /**
     * @var float
     */
    protected $balloonRate;

    public function __construct(array $dataArray)
    {
        foreach ($dataArray as $key => $value) {
            if (in_array($key, self::SUPPORTED_FIELDS_LIST)) {
                $this->$key = $value;
            } else {
                throw new \InvalidArgumentException("Key [" . $key . "] is not acceptable for " . self::class);
            }
        }
    }

    public function toArray(): array
    {
        $array = [];

        foreach (self::SUPPORTED_FIELDS_LIST as $field) {
            if (isset($this->$field)) {
                $array[$field] = $this->$field;
            }
        }

        return $array;
    }

    /**
     * @return float
     */
    public function getPeriod(): float
    {
        return $this->period;
    }

    /**
     * @param float $period
     */
    public function setPeriod(float $period): void
    {
        $this->period = $period;
    }

    /**
     * @return float
     */
    public function getContribution(): float
    {
        return $this->contribution;
    }

    /**
     * @param float $contribution
     */
    public function setContribution(float $contribution): void
    {
        $this->contribution = $contribution;
    }

    /**
     * @return float
     */
    public function getRepurchase(): float
    {
        return $this->repurchase;
    }

    /**
     * @param float $repurchase
     */
    public function setRepurchase(float $repurchase): void
    {
        $this->repurchase = $repurchase;
    }

    /**
     * @return float
     */
    public function getLimitKm(): float
    {
        return $this->limitKm;
    }

    /**
     * @param float $limitKm
     */
    public function setLimitKm(float $limitKm): void
    {
        $this->limitKm = $limitKm;
    }

    /**
     * @return string[]
     */
    public function getFieldsList(): array
    {
        return $this->fieldsList;
    }

    /**
     * @param string[] $fieldsList
     */
    public function setFieldsList(array $fieldsList): void
    {
        $this->fieldsList = $fieldsList;
    }

    /**
     * @return float
     */
    public function getBalloonRate(): float
    {
        return $this->balloonRate;
    }

    /**
     * @param float $balloonRate
     */
    public function setBalloonRate(float $balloonRate): void
    {
        $this->balloonRate = $balloonRate;
    }
}
