<?php

namespace FCAPoland\FinancialAPI\Model\Response;

use FCAPoland\FinancialAPI\Model\Response\Detection\FinancialProduct;

class Detection
{
    /**
     * @var FinancialProduct[][]
     */
    protected $b2b = [];

    /**
     * @var FinancialProduct[][]
     */
    protected $b2c = [];

    protected $fieldsList = [
        'b2b',
        'b2c'
    ];

    public function __construct(array $dataArray)
    {
        foreach ($dataArray as $clientType => $groupArray) {
            if (!in_array($clientType, $this->fieldsList)) {
                throw new \InvalidArgumentException(
                    "Key [" . $clientType . "] is not acceptable for " . self::class
                );
            }
            foreach ($groupArray as $groupLabel => $value) {
                foreach ($value as $data) {
                    $this->$clientType[$groupLabel][] = new FinancialProduct($data['name'], $data['calculation']);
                }
            }
        }
    }

    public function toArray(): array
    {
        $array = [];

        foreach ($this->fieldsList as $field) {
            if (isset($this->$field)) {
                $array[$field] = $this->$field;
            }
        }

        return $array;
    }

    /**
     * @return array|FinancialProduct[][]
     */
    public function getB2B(): array
    {
        return $this->b2b;
    }

    /**
     * @param bool $asArray
     * @return FinancialProduct[]
     */
    public function getFirstOfEachB2BSubgroup(bool $asArray = false): array
    {
        $array = [];

        foreach ($this->b2b as $groupKey => $items) {
            $array[$groupKey] = $asArray ? ($items[0])->toArray() : $items[0];
        }

        return $array;
    }

    /**
     * @return array|FinancialProduct[][]
     */
    public function getB2C(): array
    {
        return $this->b2c;
    }

    /**
     * @param bool $asArray
     * @return FinancialProduct[]
     */
    public function getFirstOfEachB2CSubgroup(bool $asArray = false): array
    {
        $array = [];

        foreach ($this->b2c as $groupKey => $items) {
            $array[$groupKey] = $asArray ? ($items[0])->toArray() : $items[0];
        }

        return $array;
    }
}
