# Financial Calculations API Library

A library that allows you to communicate with Financial Calculations API

# Examples

### Creating Vehicle object:

```php
$vehicle = (new \FCAPoland\FinancialAPI\Model\Request\Vehicle())
    ->setModelCode('6098MH')
    ->setModelName('MODEL_NAME')
    ->setNetPrice(122221)
    ->setGrossPrice(142221)
    ->setBaseNetPrice(122221)
    ->setBaseGrossPrice(142221)
    ->setStatus('new')
    ->setVersionId('57609M2G8000')
    ->setVersionName('VERSION_NAME')
    ->setFuelType('MHEV')
    ->setLCDV('T001');
```

### Creating RequestData object:

```php
$requestData = new \FCAPoland\FinancialAPI\Model\RequestData('jeep');
$requestData->addVehicle('1', $vehicle);
```

### Creating FinancialAPI object:

```php
$config = new \FCAPoland\FinancialAPI\Config();
$config->setHttpApiUrl('https://test.sfs.fcapoland.pl/api/');
$config->setEnvironment('staging');
$config->setWebsiteId('salon');

$financialApi = new \FCAPoland\FinancialAPI\FinancialAPI($config);
```

### Detect Stock Calculators
```php
$detectedCalculators = $financialApi->detectCalculators($requestData);
```

### Get detected types of offer
```php
$detectedCalculators->getDetectionByVehicleId('1')->getL101();
$detectedCalculators->getDetectionByVehicleId('1')->getB2B();
$detectedCalculators->getDetectionByVehicleId('1')->getB2C();
$detectedCalculators->getDetectionByVehicleId('1')->getP0p();
```

### Product Calculation
```php
$offer_id = '1';
$requestData->updateVehicleCalculatorId(
    $offer_id,
    $detectedCalculators->getDetectionByVehicleId($offer_id)->getL101()->getCalculation()->getCalculatorId()
);
$productCalculation = $financialApi->calculate($requestData);
```


