<?php

namespace FCAPoland\FinancialAPI;

class Config
{
    /**
     * @var string
     */
    private $httpApiUrl = 'http://host.docker.internal/';

    /**
     * @var string
     */
    private $environment;

    /**
     * @var string
     */
    private $website_id;

    /**
     * @return string
     */
    public function getHttpApiUrl(): string
    {
        return $this->httpApiUrl;
    }

    /**
     * @param string $httpApiUrl
     */
    public function setHttpApiUrl(string $httpApiUrl): void
    {
        if ($httpApiUrl[strlen($httpApiUrl) - 1] !== '/') {
            $httpApiUrl = $httpApiUrl . '/';
        }

        $this->httpApiUrl = $httpApiUrl;
    }

    public function getEnvironment(): ?string
    {
        return $this->environment;
    }

    public function setEnvironment(string $environment): void
    {
        $this->environment = $environment;
    }

    public function getWebsiteId(): ?string
    {
        return $this->website_id;
    }

    public function setWebsiteId(string $website_id): void
    {
        $this->website_id = $website_id;
    }
}
