<?php

namespace FCAPoland\FinancialAPI\Model\Request;

use InvalidArgumentException;

class Vehicle
{
    /**
     * @var string
     */
    protected $modelCode;

    /**
     * @var string
     */
    protected $modelName;

    /**
     * @var float
     */
    protected $netPrice;

    /**
     * @var float
     */
    protected $grossPrice;

    /**
     * @var float
     */
    protected $baseNetPrice;

    /**
     * @var float
     */
    protected $baseGrossPrice;

    /**
     * @var string
     */
    protected $status;

    /**
     * @var string
     */
    protected $versionId;

    /**
     * @var string
     */
    protected $versionName;

    /**
     * @var string
     */
    protected $lcdv;

    protected $fieldsList = [
        'modelCode',
        'modelName',
        'netPrice',
        'grossPrice',
        'baseNetPrice',
        'baseGrossPrice',
        'status',
        'versionId',
        'versionName',
        'fuelType',
        'lcdv',
    ];

    public function __construct(array $dataArray = [])
    {
        foreach ($dataArray as $key => $value) {
            if (in_array($key, $this->fieldsList)) {
                $this->$key = $value;
            } else {
                throw new InvalidArgumentException("Key [" . $key . "] is not acceptable for " . self::class);
            }
        }
    }

    public function toArray(): array
    {
        $array = [];

        foreach ($this->fieldsList as $field) {
            if (isset($this->$field)) {
                $array[$field] = $this->$field;
            }
        }

        return $array;
    }

    /**
     * @return string
     */
    public function getModelCode(): string
    {
        return $this->modelCode;
    }

    /**
     * @param string $modelCode
     * @return Vehicle
     */
    public function setModelCode(string $modelCode): self
    {
        $this->modelCode = $modelCode;
        return $this;
    }

    /**
     * @return string
     */
    public function getModelName(): string
    {
        return $this->modelName;
    }

    /**
     * @param string $modelName
     * @return Vehicle
     */
    public function setModelName(string $modelName): self
    {
        $this->modelName = $modelName;
        return $this;
    }

    /**
     * @return float
     */
    public function getNetPrice(): float
    {
        return $this->netPrice;
    }

    /**
     * @param float $netPrice
     * @return Vehicle
     */
    public function setNetPrice(float $netPrice): self
    {
        $this->netPrice = $netPrice;
        return $this;
    }

    /**
     * @return float
     */
    public function getGrossPrice(): float
    {
        return $this->grossPrice;
    }

    /**
     * @param float $grossPrice
     * @return Vehicle
     */
    public function setGrossPrice(float $grossPrice): self
    {
        $this->grossPrice = $grossPrice;
        return $this;
    }

    /**
     * @return float
     */
    public function getBaseNetPrice(): float
    {
        return $this->baseNetPrice;
    }

    /**
     * @param float $baseNetPrice
     * @return Vehicle
     */
    public function setBaseNetPrice(float $baseNetPrice): self
    {
        $this->baseNetPrice = $baseNetPrice;
        return $this;
    }

    /**
     * @return float
     */
    public function getBaseGrossPrice(): float
    {
        return $this->baseGrossPrice;
    }

    /**
     * @param float $baseGrossPrice
     * @return Vehicle
     */
    public function setBaseGrossPrice(float $baseGrossPrice): self
    {
        $this->baseGrossPrice = $baseGrossPrice;
        return $this;
    }

    public function getStatus(): string
    {
        return $this->status;
    }

    public function setStatus(string $status): self
    {
        $this->status = $status;
        return $this;
    }

    /**
     * @return string
     */
    public function getVersionId(): string
    {
        return $this->versionId;
    }

    /**
     * @param string $versionId
     * @return Vehicle
     */
    public function setVersionId(string $versionId): self
    {
        $this->versionId = $versionId;
        return $this;
    }

    /**
     * @return string
     */
    public function getVersionName(): string
    {
        return $this->versionName;
    }

    /**
     * @param string $versionName
     * @return Vehicle
     */
    public function setVersionName(string $versionName): self
    {
        $this->versionName = $versionName;
        return $this;
    }

    /**
     * @return string
     */
    public function getFuelType(): string
    {
        return $this->fuelType;
    }

    /**
     * @param string $fuelType
     * @return Vehicle
     */
    public function setFuelType(string $fuelType): self
    {
        $this->fuelType = $fuelType;
        return $this;
    }

    /**
     * @return string
     */
    public function getLCDV(): string
    {
        return $this->lcdv;
    }

    /**
     * @param string $lcdv
     * @return Vehicle
     */
    public function setLCDV(string $lcdv): self
    {
        $this->lcdv = $lcdv;
        return $this;
    }
}
