<?php

namespace FCAPoland\FinancialAPI\Model\Response;

use FCAPoland\FinancialAPI\Model\Response\Calculation\AvailableFields;
use FCAPoland\FinancialAPI\Model\Response\Calculation\CurrentFields;

class Calculation
{
    /**
     * @var int
     */
    protected $calculatorId;

    /**
     * @var string
     */
    protected $title;

    /**
     * @var string
     */
    protected $note;

    /**
     * @var float
     */
    protected $installment;

    /**
     * @var string
     */
    protected $priceType;

    /**
     * @var string
     */
    protected $provider;

    /**
     * @var CurrentFields
     */
    protected $currentFields;

    /**
     * @var AvailableFields
     */
    protected $availableFields;

    /**
     * @var array
     */
    protected $orderFields = [];

    /**
     * @var string
     */
    protected $clientType;

    /**
     * @var null|string
     */
    protected $psaModel;

    /**
     * @var null|string
     */
    protected $psaProduct;

    /**
     * @var null|string
     */
    protected $psaSubProduct;

    /**
     * @var bool
     */
    protected $error;

    /**
     * @var string
     */
    protected $message;

    /**
     * @var array
     */
    protected $solParams = [];

    /**
     * @var array
     */
    protected $calculationParams = [];

    /**
     * @var string
     */
    protected $vehicleLCDV;

    protected $fieldsList = [
        'calculatorId',
        'title',
        'note',
        'installment',
        'priceType',
        'provider',
        'currentFields',
        'availableFields',
        'orderFields',
        'clientType',
        'psaModel',
        'psaProduct',
        'psaSubProduct',
        'vehicleLCDV',
        'error',
        'message',
        'solParams',
        'calculationParams'
    ];

    public function __construct(array $dataArray)
    {
        foreach ($dataArray as $key => $value) {
            if (in_array($key, $this->fieldsList)) {
                switch ($key) {
                    case 'currentFields':
                        $this->$key = new CurrentFields($value);
                        break;
                    case 'availableFields':
                        $this->$key = new AvailableFields($value);
                        break;
                    default:
                        $this->$key = $value;
                }
            }
        }
    }

    public function toArray(): array
    {
        $array = [];

        foreach ($this->fieldsList as $field) {
            if (isset($this->$field)) {
                switch ($field) {
                    case 'currentFields':
                    case 'availableFields':
                        $array[$field] = $this->$field->toArray($this->getOrderFields());
                        break;
                    default:
                        $array[$field] = $this->$field;
                }
            }
        }

        return $array;
    }

    /**
     * @return int
     */
    public function getCalculatorId(): int
    {
        return $this->calculatorId;
    }

    /**
     * @return string
     */
    public function getTitle(): string
    {
        return $this->title;
    }

    /**
     * @return string
     */
    public function getNote(): string
    {
        return $this->note;
    }

    /**
     * @return float
     */
    public function getInstallment(): float
    {
        return $this->installment;
    }

    /**
     * @return string
     */
    public function getPriceType(): string
    {
        return $this->priceType;
    }

    /**
     * @return string
     */
    public function getProvider(): string
    {
        return $this->provider;
    }

    /**
     * @return CurrentFields
     */
    public function getCurrentFields(): CurrentFields
    {
        return $this->currentFields;
    }

    /**
     * @return AvailableFields
     */
    public function getAvailableFields(): AvailableFields
    {
        return $this->availableFields;
    }

    /**
     * @return array
     */
    public function getOrderFields(): array
    {
        return $this->orderFields;
    }

    public function getClientType(): string
    {
        return $this->clientType;
    }

    public function getPsaModel(): ?string
    {
        return $this->psaModel;
    }

    public function getPsaProduct(): ?string
    {
        return $this->psaProduct;
    }

    public function getPsaSubProduct(): ?string
    {
        return $this->psaSubProduct;
    }

    /**
     * @return bool
     */
    public function isError(): bool
    {
        return $this->error;
    }

    /**
     * @return string
     */
    public function getMessage(): string
    {
        return $this->message;
    }

    /**
     * @return string
     */
    public function getVehicleLCDV(): string
    {
        return $this->vehicleLCDV;
    }

    /**
     * @return array
     */
    public function getSolParams(): array
    {
        return $this->solParams;
    }

    public function getCalculationParams(): array
    {
        return $this->calculationParams;
    }
}
