<?php

namespace FCAPoland\FinancialAPI;

class Config
{
    /**
     * @var string
     */
    private $httpApiUrl = 'http://host.docker.internal/';

    /**
     * @var string
     */
    private $websocketApiUrl = 'http://host.docker.internal/ws';

    /**
     * @var string
     */
    private $environment;

    /**
     * @var string
     */
    private $website_id;

    /**
     * @var bool
     */
    private $websocket_enable = false;

    /**
     * @return string
     */
    public function getHttpApiUrl(): string
    {
        return $this->httpApiUrl;
    }

    /**
     * @param string $httpApiUrl
     */
    public function setHttpApiUrl(string $httpApiUrl): void
    {
        if ($httpApiUrl[strlen($httpApiUrl) - 1] !== '/') {
            $httpApiUrl = $httpApiUrl . '/';
        }

        $this->httpApiUrl = $httpApiUrl;
    }

    /**
     * @return string
     */
    public function getWebsocketApiUrl(): string
    {
        return $this->websocketApiUrl;
    }

    /**
     * @param string $websocketApiUrl
     * @return void
     */
    public function setWebsocketApiUrl(string $websocketApiUrl): void
    {
        if ($websocketApiUrl[strlen($websocketApiUrl) - 1] !== '/') {
            $websocketApiUrl = $websocketApiUrl . '/';
        }

        $this->websocketApiUrl = $websocketApiUrl;
    }

    public function getEnvironment(): ?string
    {
        return $this->environment;
    }

    public function setEnvironment(string $environment): void
    {
        $this->environment = $environment;
    }

    public function getWebsiteId(): ?string
    {
        return $this->website_id;
    }

    public function setWebsiteId(string $website_id): void
    {
        $this->website_id = $website_id;
    }

    public function isWebsocketEnable(): bool
    {
        return $this->websocket_enable;
    }

    public function setWebsocketEnable(bool $websocket_enable): void
    {
        $this->websocket_enable = $websocket_enable;
    }
}
