<?php

namespace FCAPoland\FinancialAPI\Model\Response;

use FCAPoland\FinancialAPI\Model\Response\Detection\FinancialProduct;
use InvalidArgumentException;

class Detection
{
    /**
     * @var string
     */
    protected $vehicleId;

    /**
     * @var null|FinancialProduct
     */
    protected $b2b = null;

    /**
     * @var null|FinancialProduct
     */
    protected $b2c = null;

    /**
     * @var null|FinancialProduct
     */
    protected $p0p = null;

    /**
     * @var null|FinancialProduct
     */
    protected $l101 = null;

    protected $fieldsList = [
        'b2b',
        'b2c',
        'p0p',
        'l101',
    ];

    public function __construct(string $vehicleId, array $dataArray)
    {
        $this->vehicleId = $vehicleId;
        foreach ($dataArray as $clientType => $data) {
            if ($data == null || (is_array($data) && !array_key_exists('calculatorId', $data))) {
                continue;
            }

            // Dla błędów
            if ($clientType == 'error' || $clientType == 'message') {
                continue;
            }
            
            if (!in_array($clientType, $this->fieldsList)) {
                throw new InvalidArgumentException(
                    "Key [" . $clientType . "] is not acceptable for " . self::class
                );
            }

            $this->$clientType = new FinancialProduct($data['calculatorId'], $data);
        }
    }

    public function getVehicleId(): string
    {
        return $this->vehicleId;
    }

    public function toArray(): array
    {
        $array = [];

        foreach ($this->fieldsList as $field) {
            $array[$field] = $this->$field;
        }
        return $array;
    }

    /**
     * @return null|FinancialProduct
     */
    public function getB2B(): ?FinancialProduct
    {
        return $this->b2b;
    }

    /**
     * @return null|FinancialProduct
     */
    public function getB2C(): ?FinancialProduct
    {
        return $this->b2c;
    }

    /**
     * @return null|FinancialProduct
     */
    public function getP0p(): ?FinancialProduct
    {
        return $this->p0p;
    }

    /**
     * @return null|FinancialProduct
     */
    public function getL101(): ?FinancialProduct
    {
        return $this->l101;
    }
}
